/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.libzoomer.mixin;

import io.github.ennuil.libzoomer.api.ZoomInstance;
import io.github.ennuil.libzoomer.api.ZoomRegistry;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_312.class})
public class MouseMixin {
    @Final
    @Shadow
    private class_310 field_1779;
    @Unique
    private double cursorSensitivity;
    @Unique
    private boolean modifyMouse;
    @Unique
    private double finalCursorDeltaX;
    @Unique
    private double finalCursorDeltaY;

    @Inject(at={@At(value="FIELD", target="net.minecraft.client.option/GameOptions.smoothCameraEnabled:Z")}, method={"updateMouse()V"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void getSensitivity(CallbackInfo ci, double e, double f, double g, double h) {
        this.cursorSensitivity = h;
    }

    @Inject(at={@At(value="FIELD", target="net/minecraft/client/Mouse.cursorDeltaX:D", ordinal=4)}, method={"updateMouse()V"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void applyZoomChanges(CallbackInfo ci, double e, double k, double l) {
        this.modifyMouse = false;
        for (ZoomInstance instance : ZoomRegistry.getZoomInstances()) {
            boolean zoom;
            if (instance.getMouseModifier() == null || !(zoom = instance.getZoom()) && !instance.isModifierActive()) continue;
            instance.getMouseModifier().tick(zoom);
            double zoomDivisor = zoom ? instance.getZoomDivisor() : 1.0;
            double transitionDivisor = instance.getTransitionMode().getInternalMultiplier();
            k = instance.getMouseModifier().applyXModifier(k, this.cursorSensitivity, e, zoomDivisor, transitionDivisor);
            l = instance.getMouseModifier().applyYModifier(l, this.cursorSensitivity, e, zoomDivisor, transitionDivisor);
            this.modifyMouse = true;
        }
        this.finalCursorDeltaX = k;
        this.finalCursorDeltaY = l;
    }

    @ModifyArgs(at=@At(value="INVOKE", target="net/minecraft/client/tutorial/TutorialManager.onUpdateMouse(DD)V"), method={"updateMouse()V"})
    private void modifyTutorialUpdate(Args args) {
        if (!this.modifyMouse) {
            return;
        }
        args.set(0, (Object)this.finalCursorDeltaX);
        args.set(1, (Object)this.finalCursorDeltaY);
    }

    @ModifyArgs(at=@At(value="INVOKE", target="net/minecraft/client/network/ClientPlayerEntity.changeLookDirection(DD)V"), method={"updateMouse()V"})
    private void modifyLookDirection(Args args) {
        if (!this.modifyMouse) {
            return;
        }
        args.set(0, (Object)this.finalCursorDeltaX);
        args.set(1, (Object)(this.finalCursorDeltaY * (double)(this.field_1779.field_1690.field_1865 ? -1 : 1)));
    }
}

